IF  NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EST_PROD_LIST_GENEXIS]') AND type in (N'U'))
begin
	SET ANSI_NULLS ON

	SET QUOTED_IDENTIFIER ON

	CREATE TABLE [dbo].[EST_PROD_LIST_GENEXIS](
		[CD_EMP] [int] NOT NULL,
		[CD_PROD] [int] NOT NULL,
		[DT_CAD] [datetime] NULL,
	 CONSTRAINT [PK_EST_PROD_LIST_GENEXIS] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_PROD] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]


	ALTER TABLE [dbo].[EST_PROD_LIST_GENEXIS]  WITH NOCHECK ADD  CONSTRAINT [FK_EST_PROD_LIST_GENEXIS_EST_PROD] FOREIGN KEY([CD_EMP], [CD_PROD])
	REFERENCES [dbo].[EST_PROD] ([CD_EMP], [CD_PROD])
	ON UPDATE CASCADE

	ALTER TABLE [dbo].[EST_PROD_LIST_GENEXIS] CHECK CONSTRAINT [FK_EST_PROD_LIST_GENEXIS_EST_PROD]

end
